<?php
require_once "../db/database.php";

// Pārbauda, vai ir norādītais grāmatas ID
if(isset($_GET['id'])) {
    $bookId = $_GET['id'];

    // Pieprasījums, kas atlasīta grāmatu pēc ID
    $query = "SELECT * FROM books WHERE id = ?";
    $statement = $mysqli->prepare($query);
    $statement->bind_param("i", $bookId); 
    $statement->execute();
    $result = $statement->get_result();

    // Pieprasījums, kas iegūst visas grāmatas atsauksmes
    $query = 
    "SELECT ROUND(AVG(rating), 1) AS average, COUNT(*) AS count 
     FROM reviews 
     WHERE id_book = ?
    ";
    
    $statement = $mysqli->prepare($query);
    $statement->bind_param("i", $bookId);
    $statement->execute();
    $result_review = $statement->get_result()->fetch_assoc();
    $average = $result_review['average'];
    if (substr($average, -2) == '.0') {
        $average = substr($average, 0, -2);
    }
    $count = $result_review['count'];

    // Ja ir iegūtas grāmatas, izvada grāmatas informāciju
    if($result->num_rows > 0) {
        $book = $result->fetch_assoc();
        // Izvada HTML struktūru, lai izveidotu iznirstošo logu ar grāmatas informāciju
        echo '<div class="popup-content">';
        echo '<span class="close-btn" onclick="closePopup()">&times;</span>';
        echo '<div class="popup-book-info">';
        echo '<div class="popup-book-image">';
        echo '<img id="popup-book-image" src="../uploads/' . $book['image'] . '" alt="">';
        echo '</div>';
        echo '<div class="popup-book-details">';
        echo '<h2 id="popup-book-title">' . $book['title'] . '</h2>';
        echo '<p id="popup-book-rating">Vērtējums: '. $average .'/5' . '</p>';
        echo '<a href="http://lasitava.000webhostapp.com/review/review.php?bookId='. $book['id'] .'" id="popup-book-review">Atsauksmes('. $count .')</a>';
        echo '<p id="popup-book-description">' . 'Autors: ' . $book['author'] 
                                               . '<br>'
                                               . 'Gads: ' . $book['year'] 
                                               . '<br>' 
                                               . '<br>'
                                               . $book['description'] . '</p>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
    } else {
        // Ja grāmata nav atrasta, izvada kļūdas ziņojumu
        echo '<div class="popup-content">';
        echo '<p class="error-message">Grāmata nav atrasta</p>';
        echo '</div>';
    }
} else {
    // Ja nav norādītais grāmatas ID, izvada kļūdas ziņojumu
    echo '<div class="popup-content">';
    echo '<p class="error-message">Nav norādīts grāmatas ID</p>';
    echo '</div>';
}


